/**
 * Some of these scripts were taken from wikipedia.org and were modified for DokuWiki
 */

/**
 * Some browser detection
 */
var clientPC  = navigator.userAgent.toLowerCase(); // Get client info
var is_gecko  = ((clientPC.indexOf('gecko')!=-1) && (clientPC.indexOf('spoofer')==-1)
                && (clientPC.indexOf('khtml') == -1) && (clientPC.indexOf('netscape/7.0')==-1));
var is_safari = ((clientPC.indexOf('AppleWebKit')!=-1) && (clientPC.indexOf('spoofer')==-1));
var is_khtml  = (navigator.vendor == 'KDE' || ( document.childNodes && !document.all && !navigator.taintEnabled ));
if (clientPC.indexOf('opera')!=-1) {
    var is_opera = true;
    var is_opera_preseven = (window.opera && !document.childNodes);
    var is_opera_seven = (window.opera && document.childNodes);
}


/**
 * This function escapes some special chars
 */
function escapeQuotes(text) {
  var re=new RegExp("'","g");
  text=text.replace(re,"\\'");
  re=new RegExp('"',"g");
  text=text.replace(re,'&quot;');
  re=new RegExp("\\n","g");
  text=text.replace(re,"\\n");
  return text;
}


/**
 * This function generates the actual toolbar buttons with localized text
 * we use it to avoid creating the toolbar where javascript is not enabled
 */
function formatButton(idElement,imageFile, speedTip, tagOpen, tagClose, sampleText, accessKey) {
  speedTip=escapeQuotes(speedTip);
  tagOpen=escapeQuotes(tagOpen);
  tagClose=escapeQuotes(tagClose);
  sampleText=escapeQuotes(sampleText);

  document.write("<a ");
  if(accessKey){
    document.write("accesskey=\""+accessKey+"\" ");
    speedTip = speedTip+' [ALT+'+accessKey.toUpperCase()+']';
  }
  document.write("href=\"javascript:insertTags");
  document.write("('"+tagOpen+"','"+tagClose+"','"+sampleText+"','"+idElement+"');\">");

  document.write("<img width=\"24\" height=\"24\" src=\""+
                'images/toolbar/'+imageFile+"\" border=\"0\" alt=\""+
                speedTip+"\" title=\""+speedTip+"\">");
  document.write("</a>");
  return;
}

/**
 * This function generates the actual toolbar buttons with localized text
 * we use it to avoid creating the toolbar where javascript is not enabled
 */
function insertButton(imageFile, speedTip, value, accessKey) {
  speedTip=escapeQuotes(speedTip);
  value=escapeQuotes(value);

  document.write("<a ");
  if(accessKey){
    document.write("accesskey=\""+accessKey+"\" ");
    speedTip = speedTip+' [ALT+'+accessKey.toUpperCase()+']';
  }
  document.write("href=\"javascript:insertAtCarret");
  document.write("(document.altaNota._nota,'"+value+"');\">");

  document.write("<img width=\"24\" height=\"24\" src=\""+
                'images/toolbar/'+imageFile+"\" border=\"0\" alt=\""+
                speedTip+"\" title=\""+speedTip+"\">");
  document.write("</a>");
  return;
}


/**
 * apply tagOpen/tagClose to selection in textarea, use sampleText instead
 * of selection if there is none copied and adapted from phpBB
 *
 * @author phpBB development team
 * @author MediaWiki development team
 * @author Andreas Gohr <andi@splitbrain.org>
 * @author Jim Raynor <jim_raynor@web.de>
 */
function insertTags(tagOpen, tagClose, sampleText,idElement) {

   var txtarea = document.getElementById(idElement);
  // IE
  if(document.selection  && !is_gecko) {
    var theSelection = document.selection.createRange().text;
    var replaced = true;
    if(!theSelection){
      replaced = false;
      theSelection=sampleText;
    }
    txtarea.focus();

    // This has change
    text = theSelection;
    if(theSelection.charAt(theSelection.length - 1) == " "){// exclude ending space char, if any
      theSelection = theSelection.substring(0, theSelection.length - 1);
      r = document.selection.createRange();
      r.text = tagOpen + theSelection + tagClose + " ";
    } else {
      r = document.selection.createRange();
      r.text = tagOpen + theSelection + tagClose;
    }
    if(!replaced){
      r.moveStart('character',-text.length-tagClose.length);
      r.moveEnd('character',-tagClose.length);
    }
    r.select();
  // Mozilla
  } else if(txtarea.selectionStart || txtarea.selectionStart == '0') {
    var replaced = false;
    var startPos = txtarea.selectionStart;
    var endPos   = txtarea.selectionEnd;
    if(endPos - startPos) replaced = true;
    var scrollTop=txtarea.scrollTop;
    var myText = (txtarea.value).substring(startPos, endPos);
    if(!myText) { myText=sampleText;}
    if(myText.charAt(myText.length - 1) == " "){ // exclude ending space char, if any
      subst = tagOpen + myText.substring(0, (myText.length - 1)) + tagClose + " ";
    } else {
      subst = tagOpen + myText + tagClose;
    }
    txtarea.value = txtarea.value.substring(0, startPos) + subst +
                    txtarea.value.substring(endPos, txtarea.value.length);
    txtarea.focus();

    //set new selection
    if(replaced){
      var cPos=startPos+(tagOpen.length+myText.length+tagClose.length);
      txtarea.selectionStart=cPos;
      txtarea.selectionEnd=cPos;
    }else{
      txtarea.selectionStart=startPos+tagOpen.length;
      txtarea.selectionEnd=startPos+tagOpen.length+myText.length;
    }
    txtarea.scrollTop=scrollTop;
  // All others
  } else {
    var copy_alertText=alertText;
    var re1=new RegExp("\\$1","g");
    var re2=new RegExp("\\$2","g");
    copy_alertText=copy_alertText.replace(re1,sampleText);
    copy_alertText=copy_alertText.replace(re2,tagOpen+sampleText+tagClose);
    var text;
    if (sampleText) {
      text=prompt(copy_alertText);
    } else {
      text="";
    }
    if(!text) { text=sampleText;}
    text=tagOpen+text+tagClose;
    //append to the end
    txtarea.value += "\n"+text;

    // in Safari this causes scrolling
    if(!is_safari) {
      txtarea.focus();
    }

  }
  // reposition cursor if possible
  if (txtarea.createTextRange) txtarea.caretPos = document.selection.createRange().duplicate();
}




/**
 * Change textarea size
 * Based on @author peterbe.com <mail@peterbe.com>
 * Source : </mail@peterbe.com> <http://www.peterbe.com/Changing-textarea-size>
 */

function makeBigger(direction,idElement) {

  var txtarea = document.getElementById(idElement);
  if (direction==1) {
    txtarea.cols = txtarea.cols + 10;
    txtarea.rows = txtarea.rows + 3;
  } else {
    txtarea.cols = txtarea.cols - 10;
    txtarea.rows = txtarea.rows - 3;
  }

}


